#define comment ___comment
#include "core.h"
#undef comment
#include "process.h"
#include "master.h"
#include "sigmask.h"
#include "frame.h"
#include "memory.h"
#include "symtab.h"
#include "symbol.h"
#include "srcdir.h"
#include "asm.h"
#include "bpts.h"
#include "dbmonitor/dbmonitor.h"
#include "rt.h"
#include "unix.h"
SRCFILE("unix.c")

#define	K	DB_KERNELID

extern char *PATH;

UnixMaster::UnixMaster(int f,int i,int p,RtNode* n):
 RtMaster(f, i, p, n), wd(f, i) {}

Process	*UnixMaster::newProcess(Process *pr, char *p, char *s, char* c)
{
	return new UnixProcess(fd, boardid, pipeid, pr, p, s, c);
}

void UnixMaster::open()
{
	Menu m, cd;
	char c[DB_MAX_SIZE];

	if (pad) {
		pad->makecurrent();
		return;
	}
	pad = new Pad( (PadRcv*) this );
	pad->options(TRUNCATE|SORTED|ACCEPT_KBD);
	pad->name( "%s:pi", name());
	dbrequest(fd, boardid, K, DBR_GETOSNAME, (int)c, 0, sizeof(c));
	pad->banner( "Rtpi - %s:%s", name(), c);
	dbrequest(fd, boardid, K, DBR_GETPSCMDS, (int)c, 0, sizeof(c));
	char *cp = c;
	long i = 1;
	for( ; *cp; i++ ){
		m.last( cp, (Action)&UnixMaster::refresh, i );
		cp += strlen(cp) + 1;
	}
	cd.last("cd", (Action)&UnixMaster::wdopen);
	m.last(cd.index("cd"));
	pad->menu(m.index("ps"));
	pad->makecurrent();
	refresh(0);
}

void UnixMaster::wdopen()	{ wd.open(); }

#define PSOUT 100
#define PROCS 100
char *UnixMaster::dopscmd(int cmd)
{
	char psout[PROCS][PSOUT];
	char c[DB_MAX_SIZE];
	int pid, i, j, l;

	if( !cmd ) return 0;
	cmd--;
	char *cp = c;
	*cp = 1;
	for(i = 0;;) {
		if (*cp == 0)
			break;
		else if (*cp == 1) {
			dbrequest(fd, boardid, K, DBR_DOPSCMD, (int)c,
				cmd, sizeof(c));
			cp = c;
		}
		else {
			l = strchr(cp, '\n') - cp + 1;
			if (i < PROCS) {
				memcpy(psout[i], cp, l);
				psout[i][l+1] = '\0';
				i++;
			}
			cp += l;
		}
	}
	if( *++cp )
		return sf( "DBR_DOPSCMD: exit(%d)", *cp);
	for( j = 0; j <= i; ++j )
		if( 2 == sscanf( psout[j], " %d %[^\n]", &pid, psout[0] ) )
			makeproc( sf("%05d",pid), 0, psout[0] );
	return 0;
}

void UnixMaster::refresh(int cmd)
{
	char *error;
	Process *p;

	pad->clear();
	makeproc( "core", "a.out", "" );
	makeproc( "!", "a.out", "" );
	if( error = dopscmd(cmd) ) pad->error(error);
	for( p = child; p; p = p->sibling )
		if( p->core || (p->procpath && eqstr(p->procpath,"!")))
			insert(p);
}

char *UnixMaster::kbd(char *s)
{
	char *corep, core[64], syms[64], star = 0;
	UnixProcess *p;

	while( *s == ' ' ) ++s;
	switch( *s ){
	case '!':
		for( ++s; *s==' '; ++s ) {}
		makeproc("!", s, "");
		break;
	case '*':
		star = 1;
		for( ++s; *s==' '; ++s ) {}
	default:
		switch( sscanf(s, "%s %s \n", corep = core, syms) ){
		case 2:	if( alldigits(corep) ) {
				int id;
				sscanf(corep, "%d", &id);
				corep = sf("%05d", id);
			}
			p = (UnixProcess*) makeproc(corep, syms[0]?syms:0, 0);
			if( star && p ) p->open(0);
			break;
		default:
		return "Incorrect input: type ? for help";
		}
	}
	return 0;
}

char *UnixMaster::help(long l)
{
	switch(l) {
		case HELP_OVERVIEW:	return "Remote Unix Pi Window";
		case HELP_MENU:		return "Remote Unix Pi Menu Bar";
		case HELP_KEY:		return "Remote Unix Pi Keyboard";
		case HELP_LMENU:	return "Remote Unix Pi Line Menus";
		default:		return 0;
	}
}

UnixProcess::UnixProcess(int f, int b, int pid, Process *sib, char *p,
	char *s, char *c) : Process(sib,p,s,c)
{
	fd = f;
	boardid = b;
	pipeid = pid;
}

void UnixProcess::takeover()
{
	if (pad) {
		open(0);
		insert(ERRORKEY, "take over: already open");
		return;
	}
	if (fixsymtab())
		return;
	Pick("take over", (Action)&UnixProcess::substitute, (long)this);
}

int UnixProcess::fixsymtab()
{
	char *nstab;
	char file[80];
	int i;

	if (stabpath)
		return 0;
	if (dbrequest(fd, boardid, K, DBR_GETPSFIELD, (int)&i, 0, sizeof(i))) {
		insert(ERRORKEY, "Can't determine name of symbol table");
		return 1;
	} else
		i = (int)db_ntohl(i);
	sscanf(&comment[i], "%s", file);
	if ((nstab = pathexpand(file, PATH, 5)) == 0) {
		insert(ERRORKEY, "Can't find symbol table file");
		return 1;
	}
	stabpath = sf("%s", nstab);
	comment = 0;
	master->insert(this);
	return 0;
}

int UnixProcess::accept( Action a )
{
	return a == (Action)&UnixProcess::substitute;
}

void UnixProcess::substitute(UnixProcess *t)
{
	char *error, *oldprocpath, *oldstabpath, *oldcomment;

	insert(ERRORKEY, 0);
	if( !core ){
		insert(ERRORKEY, "that ought to work - but it doesn't");
		return;
	}
	if( !core->online() ){
		insert(ERRORKEY, "cannot take over a coredump");
		return;
	}
	_bpts->lift();
	if( error = core->reopen(t->procpath, t->stabpath) ){
		_bpts->lay();
		insert(ERRORKEY, error);
		return;
	}
	oldprocpath = procpath;
	oldstabpath = stabpath;
	oldcomment = comment;
	procpath = t->procpath;
	stabpath = t->stabpath;
	comment = t->comment;
	master->makeproc( oldprocpath, oldstabpath, oldcomment );
	master->insert(t);
	master->insert(this);
	banner();
	if( _asm ) _asm->banner();
	if( _bpts ) _bpts->banner();
	if( memory ) memory->banner();
	if( globals ) globals->banner();
	if( sigmsk ){
		sigmsk->banner();
		sigmsk->updatecore();
	}
	if( srcdir ) srcdir->banner();
	core->symtab()->banner();
	pad->clear();
	_bpts->lay();
	docycle();
}

void UnixProcess::imprint()
{
	int ppid = 0;
	char *parentpath = sf("%d", ppid);
	insert(ERRORKEY, "parent=%s", parentpath);
	Process *p = master->search(parentpath);
	if (!p) {
		insert(ERRORKEY, "parent (%d) not opened", ppid);
		return;
	}
	_bpts->liftparents(p->_bpts);
}

void UnixProcess::userclose()
{
	if (sigmsk) {
		sigmsk->hostclose();
		delete sigmsk;
		sigmsk = 0;
	}
	Process::userclose();
}

void UnixProcess::open(long ischild)
{
	Menu m, s, k;
	char *error;

	Process::openpad();
	if( core ) return;
	if (fixsymtab())
		return;
	core = newCore(master);
	if (!core) {
		insert(ERRORKEY, "Processor type not supported");
		return;
	}
	insert(ERRORKEY, "Checking process and symbol table...");
	if (error = core->open()) {
		delete core;
		core = 0;
		if (ischild)
			m.last("open child", (Action)&UnixProcess::open, 1);
		else
			m.last("open process", (Action)&UnixProcess::open, 0);
		pad->menu(m);
		insert(ERRORKEY, error);
		return;
	}
	insert(ERRORKEY, core->symtab()->warn());
	globals = new Globals(core);
	_asm = core->newAsm();
	m.last( "Source",  (Action)&Process::srcfiles    );
	m.last( "Globals",   (Action)&Process::openglobals );
	m.last( "Memory", (Action)&Process::openmemory  );
	m.last( "Assembler", (Action)&Process::openasm     );
	m.last( "User Types",(Action)&Process::opentypes   );
	if( core->online() ){
		m.last("Journal", (Action)&Process::openjournal);
		m.last("Signals", (Action)&UnixProcess::opensigmask);
		m.last("Breakpoints", (Action)&Process::openbpts);
		_bpts = new Bpts(core);
		_bpts->lay();
		if( ischild ) imprint();
		sigmsk = new SigMask(core);
	}
	if( core->online() ){
		s.last("run",		(Action)&Process::go);
		s.last("stop",		(Action)&Process::stop);
		s.last("current",	(Action)&Process::currentstmt);				s.last("return",	(Action)&Process::pop);
		s.last("step into",	(Action)&Process::stepinto);
		s.last("step   1",	(Action)&Process::stmtstep, 1);
		s.last("step   5",	(Action)&Process::stmtstep, 5);
		s.last("step  25",	(Action)&Process::stmtstep, 25);
		s.last("step 100",	(Action)&Process::stmtstep, 100);
		s.last("step 500",	(Action)&Process::stmtstep, 500);
	} else
		s.first("stmt",		(Action)&Process::currentstmt);
	m.last(s.index("stmt"));
	if( core->online() ){
		k.last("kill?",		(Action)&UnixProcess::destroy);
		m.last(k.index("kill"));
	}
	pad->menu(m.index("views"));
	pad->makecurrent();
	docycle();
	return;
}

void UnixProcess::opensigmask()		{ if( sigmsk ) sigmsk->open(); }

void UnixProcess::destroy()
{
	IF_LIVE( !core->online() ) return;
	insert(ERRORKEY, core->destroy());
	docycle();
}

void UnixProcess::stop()
{
	IF_LIVE( !core->online() ) return;
	if( !(sigmsk->mask&sigmsk->bit(SIGSTOP)) ) sigmsk->setsig(SIGSTOP);
	Process::stop();
}

Index UnixProcess::carte()
{
	Menu m;
	if( !strcmp(procpath,"!") ){
		m.last( "hang & open proc", (Action)&UnixProcess::hangopen );
		m.last( "hang & take over", (Action)&UnixProcess::hangtakeover );
	} else if( alldigits(procpath) ) {
		m.last( "open process",  (Action)&UnixProcess::open );
		m.last( "take over",    (Action)&UnixProcess::takeover );
		m.last( "open child", (Action)&UnixProcess::open, 1 );
	} else
		m.last( "open coredump",(Action)&UnixProcess::open );
	return m.index();
}


void UnixProcess::hang()
{
	long pid;
	char program[128];

	dbrequest(fd, boardid, K, DBR_HANG, (int)stabpath,
		0, strlen(stabpath) + 1);
	dbrequest(fd, boardid, K, DBR_GETHANGID, (int)&pid, 0, sizeof(long));
	pid = db_ntohl(pid);
	procpath = sf("%05d", pid);
	char *ssave = stabpath;
	sscanf(stabpath, "%s", program);
	stabpath  = sf("%s", program);
	master->makeproc("!", ssave);
	master->insert(this);
}

void UnixProcess::hangopen()
{
	hang();
	open(0);
}

void UnixProcess::hangtakeover()
{
	hang();
	takeover();
}

char *UnixCore::run()		{ return dbreq(DBR_RUN); }
char *UnixCore::stop()		{ return dbreq(DBR_STOP); }
Behavs UnixCore::behavetype()	{ return behavs(); }
char *UnixCore::destroy()	{ return dbreq(DBR_KILL) ? "already dead" : 0;}
long UnixCore::regaddr()	{ return config.regaddr; }
long UnixCore::scratchaddr()	{ return config.scratchaddr; }
int UnixCore::nsig()		{ return config.nsig; }
long UnixCore::signalmaskinit()	{ return config.initsigmask; }
int UnixCore::exechangsupported() { return config.exechang; }
char *UnixCore::eventname()	{ return signalname(state.code); }
char *UnixCore::signalsend(long sig) { return dbreq(DBR_SSIG, 0, (int)sig); }
char *UnixCore::signalclear()	{ return dbreq(DBR_CSIG); }
char *UnixCore::exechang(long e) { return dbreq(DBR_HANGEXEC, 0, (int)e); }
char *UnixCore::signalmask(long m) { return dbreq(DBR_SMASK, 0, (int)m); }

UnixCore::UnixCore(int f, int b, int p)
{
	commfd = f;
	boardid = b;
	pipeid = p;
	dbrequest(f, b, K, DBR_GETCONFIG, (int)&config, 0, sizeof(config));
	db_ntohla(&config.regaddr, 5);
}

char *UnixCore::problem()
{
	static char buf[80];
	int sig;

	if (state.code & 0xFF) {
		sig = state.code & 0x7F;
		sprintf( buf, "died from signal %d(%s)",sig,signalname(sig));
	} else
		sprintf(buf, "exited with status %d",
			(state.code >> 8) & 0xFF);
	return buf;
}

char *UnixCore::dbreq(int req, char* addr,int rarg, int sz)
{ 
	if (dbrequest(commfd, boardid, procid, req, (int)addr, rarg, sz) == -1)
		return "dbrequest failed";
	return 0;
}

char *UnixCore::laybpt(Trap *t)
{
	if (bptsize && read(t->stmt->range.lo, t->saved, bptsize))
		return "laybpt: read failed";
	return dbreq(DBR_SETBKPT, 0, (int)t->stmt->range.lo);
}

Behavs UnixCore::behavs()
{
	dbreq(DBR_GETSTATE, (char*)&state, 0, sizeof(state));
	db_ntohsa(&state.state, 2);
	switch (state.state) {
		case UNIX_HALTED: return HALTED;
		case UNIX_ACTIVE: return ACTIVE;
		case UNIX_BREAKED: return BREAKED;
		case UNIX_PENDING: return PENDING;
		case UNIX_ERRORED:
		default:
			return ERRORED;
	}
}

void UnixCore::close()
{
	dbreq(DBR_CLOSE);
	Core::close();
}

char *UnixCore::open()
{
	char *s = stabpath();
	if (s) {
		stabfd = ::open(s,0);
		if (stabfd < 0) return SysErr("symbol tables: ");
	} else
		return "open error";
	char *p = procpath();
	if (alldigits(p)) {
		sscanf(p, "%d", &procid);
		_online = 1;
		if (dbreq(DBR_OPEN))
			return "can't open process";
	} else {
		char c[DB_MAX_SIZE];
		int len1 = strlen(p) + 1;
		int len2 = strlen(s) + 1;
		memcpy(c, p, len1);
		memcpy(&c[len1], s, len2);
		if (dbrequest(commfd, boardid, K, DBR_COREOPEN,
		    (int)c, 0, len1 + len2) == -1)
			return "can't open core dump";
		dbrequest(commfd, boardid, K, DBR_GETCOREID,
		    (int)&procid, 0, sizeof(procid));
		procid = (int)db_ntohl(procid);
	}
	stabfstat();
	newSymTab();
	_symtab->read();
	behavs();
	return 0;
}

char *UnixCore::reopen(char *newprocpath, char *newstabpath)
{
	if( !online() || (newprocpath && !alldigits(newprocpath)) )
		return "reopen core not implemented";
	int compstabfd = ::open(newstabpath, 0);
	struct stat compstabstat;
	if( compstabfd < 0 || ::fstat(compstabfd, &compstabstat) )
		return "symbol table error";
	if( compstabstat.st_mtime != stabstat.st_mtime )
		return "symbol tables differ (modified time)";
	if( compstabstat.st_size != stabstat.st_size )
		return "symbol tables differ (file size)";
	::close(compstabfd);
	dbreq(DBR_CLOSE);
	sscanf(newprocpath, "%d", &procid);
	if (dbreq(DBR_OPEN))
		return "can't connect to new process";
	behavs();
	return 0;
}

char *UnixCore::readwrite(long offset, char *buf, int r, int w)
{
	if( r ) return dbreq(DBR_READ, buf, (int)offset, r);
	return dbreq(DBR_WRITE, buf, (int)offset, w);
}

const int	STEPWAIT = 15;
char *UnixCore::dostep(long lo, long hi, int sstep)
{
	char *error;
	long fp0, pcs, time0;

	time0 = ::time((long*)0);
	for(fp0 = fp(), pcs = pc();;){
		if( hi && atjsr(pcs) ) {
			error = stepoverjsr();
			goto next;
		}
		if (sstep)
			error = dbreq(DBR_STEP);
		else {
			error = run();
			if (!error) {
				error = dbreq(DBR_WAITSTOP);
				if (error)
					stop();
			}
		}
		if( !error && behavetype() != BREAKED)
			return "step error";
next:
		if( error ) return error;
		if( !hi || (pcs = pc()) < lo || pcs >= hi
		 || ((stackdir == GROWDOWN ? (fp() > fp0) : (fp() < fp0))
		     && !atreturn(pcs)) )
			return 0;
		if( ::time((long*)0) > time0+STEPWAIT )
			return sf("single step timeout (%d secs)", STEPWAIT);
	}
}

int UnixCore::atsyscall()
{
	int ret = 0;
	dbreq(DBR_ATSYSCALL, (char*)&ret, 0, sizeof(ret));
	ret = (int)db_ntohl(ret);
	return ret;
}

char *UnixCore::signalname(long sig)
{
	char buf[128];

	dbreq(DBR_GETSIGNAME, buf, (int)sig, sizeof(buf));
	return sf("%s", buf);
}

char *UnixCore::resources()	
{
	static char buf[64];
	if (dbreq(DBR_GETPROCTIME, buf, 0, sizeof(buf)))
		return "";
	return buf;
}
